//
//  CRImageFormat.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/10/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Format descriptor
//////////////////////////////////////////////////////////////////////
@interface CRImageFormat : NSObject
{
	NSString*				name;
	NSBitmapImageFileType	fileType;
	NSString*				extension;
	CGFloat					compression;
}

@property (nonatomic, readonly) NSString*				name;
@property (nonatomic, readonly) NSBitmapImageFileType	fileType;
@property (nonatomic, readonly) NSString*				UTType;
@property (nonatomic, readonly) NSString*				extension;
@property (nonatomic, assign)	CGFloat					compression;

@property (nonatomic, readonly) BOOL					canVaryCompression;
@property (nonatomic, readonly) NSDictionary*			properties;

- (id)initWithName:(NSString *)aName type:(NSBitmapImageFileType)type extension:(NSString *)anExtension;
+ (id)formatWithName:(NSString *)aName type:(NSBitmapImageFileType)type extension:(NSString *)anExtension;

+ (NSArray *)typicalImageFormats;

@end